
function listarEmpresas(paginador) {


        $.ajax({
        url: "../api/empresaListar.php",
        type: "POST",
        data: "paginador="+paginador,
        dataType: "json",
        cache: false,
        success: function(dataServer){
            

            if (dataServer.retorno == 1){

                var novaLinha="";

                function percorreElementos(elemento){
                    
                    

                    novaLinha += "<tr id='R"+elemento.id+"'>";
                    novaLinha += "<td>"+elemento.id+"</td>";
                    novaLinha += "<td id='N"+elemento.id+"'>"+elemento.nome_fantasia+"</td>";
                    novaLinha += "<td>"+elemento.razao_social+"</td>";

                    novaLinha += "<td>";
                    if (elemento.cliente == 'S') novaLinha += "<span class='btn btn-block btn-outline-primary btn-xs'>cliente</span><br>";
                    if (elemento.parceira == 'S') novaLinha += "<span class='btn btn-block btn-outline-warning btn-xs'>parceiro</span>";
                    novaLinha += "</td>";
                    
                    if (elemento.ativo == 'S') novaLinha += "<td class='d-flex justify-content-center'><span class='btn btn-block btn-outline-success btn-xs' style='width:30px;'>s</span></td>";
                    else novaLinha += "<td class='d-flex justify-content-center'><span class='btn btn-block btn-outline-danger btn-xs' style='width:30px;'>n</span></td>";

                    novaLinha += "<td>"+elemento.cnpj+"</td>";
                    novaLinha += "<td>"+elemento.endereco+"</td>";
                    novaLinha += "<td>"+elemento.numero+"</td>";
                    novaLinha += "<td>"+elemento.complemento+"</td>";
                    novaLinha += "<td>"+elemento.cidade+"</td>";
                    novaLinha += "<td>"+elemento.estado+"</td>";

                    novaLinha += "<td>"+elemento.cep+"</td>";
                    novaLinha += "<td>"+elemento.email+"</td>";
                    novaLinha += "<td>"+elemento.fone1+"</td>";
                    novaLinha += "<td>"+elemento.fone2+"</td>";


                    novaLinha += "<td>"+botaoEditar.replace("<#conteudo#>", "empresaEditar("+elemento.id+")")+"&nbsp;";
                    novaLinha += botaoExcluir.replace("<#conteudo#>", "empresaExcluirConfirmacao("+elemento.id+")")+"&nbsp;";
                    novaLinha += botaoImagem.replace("<#conteudo#>", "empresaEditarImagem("+elemento.id+")")+"&nbsp;";
                    
                    if (elemento.cliente == "S") novaLinha += botaoUsuarios.replace("<#conteudo#>", "carregaClientesEmpresa("+elemento.id+")")+"</td>";
                    else novaLinha += "</td>";


                    
                    novaLinha += "</tr>";
                    
                    $("#listaEmpresas").append(novaLinha);

                    novaLinha = "";
                }
                dataServer.empresas.forEach(percorreElementos);
            }

            $('#listaEmpresas').DataTable( {
                "dom": 'Bfrtip',
                "buttons": [
                    'colvis',
                    'excel',
                    'pdf',
                    'print'
                ],
                "language": {"url": "./inc/DataTable-pt-BR.json"},
                "responsive" : true,
                "lengthChange": false,
                "autoWidth": false,
                "pageLength": 100,
                "order": [],
                "columnDefs": [
                        {"targets": [5],"visible": false,"searchable": true},
                        {"targets": [6],"visible": false,"searchable": true},
                        {"targets": [7],"visible": false,"searchable": true},
                        {"targets": [8],"visible": false,"searchable": true},
                        {"targets": [9],"visible": false,"searchable": true},
                        {"targets": [10],"visible": false,"searchable": true},
                        {"targets": [11],"visible": false,"searchable": true},
                        {"targets": [12],"visible": false,"searchable": true},
                        {"targets": [13],"visible": false,"searchable": true},
                        {"targets": [14],"visible": false,"searchable": true}
                    ]
            } );   

            
        },
        error: function(){
            toastr.error('Ocorreu um erro ao acessar os dados.', 'ERRO!'); 
        }


    });

    
}


function empresaExcluirConfirmacao(id){
    
    $("#modalExclusaoMensagem").text('Deseja excluir a empresa "'+$("#N"+id).text()+'"?'); 
    $("#modalExclusaoBotao").attr("onclick", "empresaExcluir("+id+")");
    $('#modalExclusao').modal('show');
    
}


function empresaExcluir(id){
    
    $('#modalExclusao').modal('hide');
    $.ajax({
        url: "../api/empresaExcluir.php",
        type: "GET",
        data: "id="+id,
        dataType: "json",
        cache: false,
        success: function(dataServer){
            
            if (dataServer.retorno == 1){

                 $("#R"+id).fadeOut(400); 
                 toastr.success('Registro excluido com sucesso.');
                
            }
            else toastr.error('Ocorreu um erro ao executar a tarefa.', 'ERRO!'); 
            
        },
        error: function(){
            toastr.error('Ocorreu um erro ao executar a tarefa.', 'ERRO!'); 
        }

    });
    
}


function empresaNovo(){
    carregaPagina('empresaNovoForm');
}


function carregaTiposEmpresas(){
    $('#modalExclusao').modal('hide');
    $.ajax({
        url: "../api/app/tiposEstabelecimentos.php",
        type: "GET",
        dataType: "json",
        cache: false,
        success: function(dataServer){
            
            if (dataServer.retorno == 1){

                 var novaLinha="";

                function percorreElementos(elemento){
                    
                    novaLinha += "<option value='"+elemento.id+"'>"+elemento.descricao+"</option>";
                    
                    $("[name='tipo_estabelecimento']").append(novaLinha);

                    novaLinha = "";
                }
                dataServer.tipo_estabelecimentos.forEach(percorreElementos);
                
            }
            
            
        },
        error: function(){
            toastr.error('Ocorreu um erro ao carregar os tipos de empresas.', 'ERRO!'); 
        }

    });
}

function empresaSalvar(tipo){

    
    loader('on');


    if ($('[name="razao_social"]').val() == ''  && $('[name="nome_fantasia"]').val() == '') {toastr.warning('O campo Nome Fantasia ou Razão Social deve ser preenchido, ATENÇÃO!'); loader('off');}
    else if ($('[name="senha"]').val() == '') {toastr.warning('A senha não pode ser vazia', 'ATENÇÃO!'); loader('off');}
    else if ($('[name="senha"]').val() != $('[name="senha2"]').val()){ toastr.error('As senhas não são iguais', 'ATENÇÃO!'); loader('off');}
    else{

            var data = $("#formEmpresa").serialize();

            $.ajax({
                url: "../api/empresaSalvar.php",
                type: "POST",
                data: data,
                dataType: "json",
                cache: false,
                success: function(dataServer){
                    
                    if (dataServer.retorno == 1) {
                        toastr.success('Registro criado com sucesso.');
                        if (tipo == "N"){
                            empresaEditarImagem(dataServer.id,'N');
                        }
                        else carregaPagina('empresas');
                    }
                    else if (dataServer.retorno == -2) toastr.error('O login já está sendo utilizado por outro usuário!', 'ATENÇÃO!');
                    else toastr.error('Ocorreu um erro ao executar a tarefa.', 'ERRO!'); 

                     loader('off');
                    
                },
                error: function(){
                    toastr.error('Ocorreu um erro ao executar a tarefa.', 'ERRO!'); 
                }

            });
        }
        
}



function empresaEditar(id){
    carregaPagina('empresaEditarForm', id);
}



function carregaDadosEmpresa(id) {


        $.ajax({
        url: "../api/empresaDados.php",
        type: "POST",
        data: "id="+id,
        dataType: "json",
        cache: false,
        success: function(dataServer){
            

            if (dataServer.retorno == 1){


                   $("[name='id']").val(dataServer.empresas[0].id);
                   $("[name='login']").val(dataServer.empresas[0].login);
                   $("[name='tipo']").val(dataServer.empresas[0].tipo);
                   $("[name='cliente']").val(dataServer.empresas[0].cliente); 
                   $("[name='parceira']").val(dataServer.empresas[0].parceira); 
                   $("[name='nome_fantasia']").val(dataServer.empresas[0].nome_fantasia); 
                   $("[name='razao_social']").val(dataServer.empresas[0].razao_social); 
                   $("[name='cnpj']").val(dataServer.empresas[0].cnpj); 
                   $("[name='descricao']").val(dataServer.empresas[0].descricao); 
                   $("[name='obs']").val(dataServer.empresas[0].obs); 
                   $("[name='endereco']").val(dataServer.empresas[0].endereco); 
                   $("[name='numero']").val(dataServer.empresas[0].numero); 
                   $("[name='complemento']").val(dataServer.empresas[0].complemento); 
                   $("[name='cidade']").val(dataServer.empresas[0].cidade); 
                   $("[name='estado']").val(dataServer.empresas[0].estado); 
                   $("[name='cep']").val(dataServer.empresas[0].cep); 
                   $("[name='email']").val(dataServer.empresas[0].email); 
                   $("[name='fone1']").val(dataServer.empresas[0].fone1); 
                   $("[name='fone2']").val(dataServer.empresas[0].fone2);
                   $("[name='latitude']").val(dataServer.empresas[0].latitude); 
                   $("[name='longitude']").val(dataServer.empresas[0].longitude); 
                   $("[name='ativo']").val(dataServer.empresas[0].ativo);
                   $("[name='tipo_estabelecimento']").val(dataServer.empresas[0].tipo_estabelecimento);
                   $("[name='senha']").val("########");
                   $("[name='senha2']").val("########");  

                   
            }
            else toastr.error('Registro não localizado.', 'ERRO!'); 
            
        },
        error: function(){
            toastr.error('Ocorreu um erro ao acessar os dados.', 'ERRO!'); 
        }


    });

    
}



function empresaImagem(id, tipo){

    bsCustomFileInput.init();
    
    $("#id").val(id);

    empresaArquivoImagem(id);

    if (tipo == 'N'){
        $("#caminhoPao").html("Novo");
        $("#titulo").html("Nova Empresa");
    }

    $('#empresaImagem').change(function (event) {
        form = new FormData();
        form.append('empresaImagem', event.target.files[0]); // para apenas 1 arquivo
        form.append('id', id);
        //var name = event.target.files[0].content.name; // para capturar o nome do arquivo com sua extenção
    });

    $('#botaoEnviar').click(function () {
        $(".loader").show();
        $.ajax({
            url: '../api/empresaUploadImagem.php', // Url do lado server que vai receber o arquivo
            data: form,
            processData: false,
            contentType: false,
            type: 'POST',
            success: function (data) {
                $(".loader").hide();
                empresaArquivoImagem(id);
                toastr.success('Imagem incluida com sucesso.');
            }
        });
    });
   

}



function empresaArquivoImagem(id){

    $.ajax({
        url: "../api/empresaArquivoImagem.php",
        type: "GET",
        data: "id="+id,
        dataType: "json",
        cache: false,
        success: function(dataServer){
            

            if (dataServer.retorno == 1) {
                $("#imagem").attr('src',dataServer.imagem);
                $("#imagem").show();
                $("#botaoExcluirImagem").show();
            }
            else{
                $("#imagem").hide();
                $("#botaoExcluirImagem").hide();
            }
            
            
        },
        error: function(){
            toastr.error('Ocorreu um erro ao acessar os dados.', 'ERRO!'); 
        }


    });

    
}


function empresaEditarImagem(id, tipo){

    carregaPagina('empresaEditarImagem',id,tipo);

}


function empresaImagemExcluirConfirmacao(){
    
    $("#modalExclusaoMensagem").text("Deseja excluir a imagem ?"); 
    $("#modalExclusaoBotao").attr("onclick", "empresaExcluirImagem()");
    $('#modalExclusao').modal('show');
    
}

function empresaExcluirImagem(){
    
    $('#modalExclusao').modal('hide');
    $('#botaoExcluirImagem').hide();
    $('.loader').show();

    var id = $("#id").val();

    $.ajax({
        url: "../api/empresaExcluirImagem.php",
        type: "GET",
        data: "id="+id,
        dataType: "json",
        cache: false,
        success: function(dataServer){
            
            $('.loader').hide();

            if (dataServer.retorno == 1){

                 $('#imagem').hide();
                 toastr.success('Imagem excluida com sucesso.');
                
            }
            else {
                $('#botaoExcluirImagem').show();
                toastr.error('Ocorreu um erro ao executar a tarefa.', 'ERRO!'); 
            }
            
        },
        error: function(){
            $('#botaoExcluirImagem').show();
            toastr.error('Ocorreu um erro ao executar a tarefa.', 'ERRO!'); 
        }

    });
    
}

function carregaClientesEmpresa(id){
    carregaPagina('clientes',id);
}
