
function carregaDadosDashboard(id) {

        $(".loader").show();

        $.ajax({
        url: "../api/dashboard.php",
        type: "GET",
        data: "intervaloDatas="+$('#intervaloDatas').val(),
        dataType: "json",
        cache: false,
        success: function(dataServer){
            

            if (dataServer.retorno == 1){

                   $("#ofertasAtivas").html(dataServer.ofertasAtivas);
                   $("#cuuponsAtivadosMes").html(dataServer.cuuponsAtivadosMes);
                   $("#usuariosRegistrados").html(dataServer.usuariosRegistrados);
                   $("#visitasUnicas").html(dataServer.visitasUnicas);
                   $("#totalOfertas").html(dataServer.totalOfertas);
                   $("#cuponsUtilizados").html(dataServer.cuponsUtilizados);
                   $("#clientesCadastrados").html(dataServer.clientesCadastrados);
                   $("#visitasTotais").html(dataServer.visitasTotais);
                   $("#totalProdutosServicos").html("R$  "+dataServer.totalProdutosServicos);
                   $("#totalDescontos").html("R$  "+dataServer.totalDescontos);
                   $("#porcentagemDescontos").html(dataServer.porcentagemDescontos+" %");
                   

                   graficosDashboard(dataServer);
                   
            }
            else toastr.error('Dados da dashboard não localizados.', 'ERRO!'); 
            
        },
        error: function(){
            toastr.error('Ocorreu um erro ao acessar os dados.', 'ERRO!'); 
        }


    });

    
}




function graficosDashboard(dataServer) {
  'use strict'

  /* Chart.js Charts */
  // Sales chart
  var salesChartCanvas = document.getElementById('revenue-chart-canvas').getContext('2d')
  // $('#revenue-chart').get(0).getContext('2d');

  var salesChartData = {
    labels: [retornaMes(dataServer.mes1),retornaMes(dataServer.mes2),retornaMes(dataServer.mes3),retornaMes(dataServer.mes4)],
    datasets: [
      {
        label: 'Descontos',
        backgroundColor: 'rgba(210, 214, 222, 1)',
        borderColor: 'rgba(210, 214, 222, 1)',
        pointRadius: false,
        pointColor: 'rgba(210, 214, 222, 1)',
        pointStrokeColor: '#c1c7d1',
        pointHighlightFill: '#fff',
        pointHighlightStroke: 'rgba(220,220,220,1)',
        data: [dataServer.totalMes1U, dataServer.totalMes2U, dataServer.totalMes3U, dataServer.totalMes4U]
      },
      {
        label: 'Valor produto/serviço',
        backgroundColor: 'rgba(60,141,188,0.9)',
        borderColor: 'rgba(60,141,188,0.8)',
        pointRadius: false,
        pointColor: '#3b8bba',
        pointStrokeColor: 'rgba(60,141,188,1)',
        pointHighlightFill: '#fff',
        pointHighlightStroke: 'rgba(60,141,188,1)',
        data: [dataServer.totalMes1, dataServer.totalMes2, dataServer.totalMes3, dataServer.totalMes4]
      }
    ]
  }

  var salesChartOptions = {
    maintainAspectRatio: false,
    responsive: true,
    legend: {
      display: true
    },
    scales: {
      xAxes: [{
        gridLines: {
          display: false
        }
      }],
      yAxes: [{
        gridLines: {
          display: false
        }
      }]
    }
  }

  // This will get the first returned node in the jQuery collection.
  // eslint-disable-next-line no-unused-vars
  var salesChart = new Chart(salesChartCanvas, { // lgtm[js/unused-local-variable]
    type: 'line',
    data: salesChartData,
    options: salesChartOptions
  })

  $(".loader").hide();
 
}

function retornaMes(mes){

    switch (mes){
       case '1': mes = 'JAN'; break;
       case '2': mes = 'FEV'; break;
       case '3': mes = 'MAR'; break;
       case '4': mes = 'ABR'; break;
       case '5': mes = 'MAI'; break;
       case '6': mes = 'JUN'; break;
       case '7': mes = 'JUL'; break;
       case '8': mes = 'AGO'; break;
       case '9': mes = 'SET'; break;
       case '10': mes = 'OUT'; break;
       case '11': mes = 'NOV'; break;
       case '12': mes = 'DEZ'; break; 
    }


    return mes;

}