function listarCupons(paginador) {


        $.ajax({
        url: "../api/cupomListar.php",
        type: "POST",
        data: "paginador="+paginador,
        dataType: "json",
        cache: false,
        success: function(dataServer){
            

            if (dataServer.retorno == 1){

                var novaLinha="";

                function percorreElementos(elemento){

                    novaLinha += "<tr id='R"+elemento.id+"'>";
                    novaLinha += "<td>"+elemento.id+"</td>";
                    novaLinha += "<td>"+elemento.titulo+"</td>";
                    novaLinha += "<td>"+elemento.nome+"</td>";
                    novaLinha += "<td id='N"+elemento.id+"'>"+elemento.cupom+"</td>";
                    novaLinha += "<td>"+elemento.data_criacao+"</td>";
                    
                    if (elemento.utilizado == 'S') novaLinha += "<td id='U"+elemento.id+"'><span class='btn btn-block btn-outline-success btn-xs' style='width:30px;'>s</span><br>"+elemento.data_utilizacao+"</td>";
                    else novaLinha += "<td id='U"+elemento.id+"'><span class='btn btn-block btn-outline-danger btn-xs' style='width:30px;'>n</span></td>";

                    novaLinha += "<td id='V"+elemento.id+"' 'style='text-align: right;'>"+elemento.valor_servico+"<br>"+elemento.desconto+"</td>";

                    novaLinha += "<td>";
                    if (tipoUsuario == 'A') novaLinha += botaoExcluir.replace("<#conteudo#>", "cupomExcluirConfirmacao("+elemento.id+")")+"&nbsp;";
                    if (elemento.utilizado == 'N') {
                        
                        btn = botaoCupom.replace("<#id#>", "btn"+elemento.id);
                        novaLinha += btn.replace("<#conteudo#>", "cupomUtilizarConfirmacao("+elemento.id+")");
                    }
                    novaLinha += "</td>";


                    novaLinha += "</tr>";
                    
                    $("#listaCupons").append(novaLinha);

                    novaLinha = "";
                }
                dataServer.cupons.forEach(percorreElementos);
            }

            $('#listaCupons').DataTable( {
                "dom": 'Bfrtip',
                "buttons": [
                    'colvis',
                    'excel',
                    'pdf',
                    'print'
                ],
                "language": {"url": "./inc/DataTable-pt-BR.json"},
                "responsive" : true,
                "lengthChange": false,
                "autoWidth": false,
                "pageLength": 100,
                "order": []
            } );   

            
        },
        error: function(){
            toastr.error('Ocorreu um erro ao acessar os dados.', 'ERRO!'); 
        }


    });

    
}


function cupomExcluirConfirmacao(id){
    
    $("#modalExclusaoMensagem").text('Deseja excluir o cupom "'+$("#N"+id).text()+'"?'); 
    $("#modalExclusaoBotao").attr("onclick", "cupomExcluir("+id+")");
    $('#modalExclusao').modal('show');
    
}


function cupomExcluir(id){
    
    $('#modalExclusao').modal('hide');
    $.ajax({
        url: "../api/cupomExcluir.php",
        type: "GET",
        data: "id="+id,
        dataType: "json",
        cache: false,
        success: function(dataServer){
            
            if (dataServer.retorno == 1){

                 $("#R"+id).fadeOut(400); 
                 toastr.success('Registro excluido com sucesso.');
                
            }
            else if (dataServer.retorno == -10) toastr.error('Permissão negada.', 'ERRO!'); 
            else toastr.error('Ocorreu um erro ao executar a tarefa.', 'ERRO!'); 
            
        },
        error: function(){
            toastr.error('Ocorreu um erro ao executar a tarefa.', 'ERRO!'); 
        }

    });
    
}


function cuponsOferta(id_oferta) {

    carregaPagina('cuponsOferta', id_oferta);
}

function cuponsOfertaListar(id_oferta) {


        $.ajax({
        url: "../api/cupomListarOferta.php",
        type: "POST",
        data: "id_oferta="+id_oferta,
        dataType: "json",
        cache: false,
        success: function(dataServer){
            

            if (dataServer.retorno == 1){



                var novaLinha="";
                var oferta = "";
                var btn = "";

                function percorreElementos(elemento){

                    oferta = elemento.titulo;

                    novaLinha += "<tr id='R"+elemento.id+"'>";
                    novaLinha += "<td>"+elemento.id+"</td>";
                    novaLinha += "<td>"+elemento.nome+"</td>";
                    novaLinha += "<td id='N"+elemento.id+"'>"+elemento.cupom+"</td>";
                    novaLinha += "<td>"+elemento.data_criacao+"</td>";
                    
                    if (elemento.utilizado == 'S') novaLinha += "<td id='U"+elemento.id+"'><span class='btn btn-block btn-outline-success btn-xs' style='width:30px;'>s</span><br>"+elemento.data_utilizacao+"</td>";
                    else novaLinha += "<td id='U"+elemento.id+"'><span class='btn btn-block btn-outline-danger btn-xs' style='width:30px;'>n</span></td>";

                    novaLinha += "<td id='V"+elemento.id+"' style='text-align: right;'>"+elemento.valor_servico+"<br>"+elemento.desconto+"</td>";

                    novaLinha += "<td>";
                    if (tipoUsuario == 'A') novaLinha += botaoExcluir.replace("<#conteudo#>", "cupomExcluirConfirmacao("+elemento.id+")")+"&nbsp;";
                    if (elemento.utilizado == 'N') {
                        
                        btn = botaoCupom.replace("<#id#>", "btn"+elemento.id);
                        novaLinha += btn.replace("<#conteudo#>", "cupomUtilizarConfirmacao("+elemento.id+")");
                    }
                    novaLinha += "</td>";
                    

                    novaLinha += "</tr>";
                    
                    $("#listaCupons").append(novaLinha);

                    novaLinha = "";
                }
                dataServer.cupons.forEach(percorreElementos);
            }

            $("#titulo").html("Cupons oferta: "+oferta);

            $('#listaCupons').DataTable( {
                "dom": 'Bfrtip',
                "buttons": [
                    'colvis',
                    'excel',
                    'pdf',
                    'print'
                ],
                "language": {"url": "./inc/DataTable-pt-BR.json"},
                "responsive" : true,
                "lengthChange": false,
                "autoWidth": false,
                "pageLength": 100,
                "order": []
            } );   

            
        },
        error: function(){
            toastr.error('Ocorreu um erro ao acessar os dados.', 'ERRO!'); 
        }


    });

    
}



function cupomUtilizarConfirmacao(id){
    
    $("#modalCupomMensagem").text('Deseja marcar como utilizado o cupom "'+$("#N"+id).text()+'"?'); 
    $("#modalCupomBotao").attr("onclick", "cupomUtilizar("+id+")");
    $("#valor").val("");
    $('#modalCupom').modal('show');
    
}


function cupomUtilizar(id){
    
    var valor = $("#valor").val();

    if (valor == "") toastr.warning('Indique o valor do produto ou serviço!, ATENÇÃO!');
    else{ 

        valor = valor.replace(",", ".");

        if (isNaN(valor)) toastr.warning('Indique um valor válido para o do produto ou serviço!, ATENÇÃO!');
        else{


                $('#modalCupom').modal('hide');
                $.ajax({
                    url: "../api/cupomUtilizar.php",
                    type: "POST",
                    data: "id="+id+"&valor="+valor,
                    dataType: "json",
                    cache: false,
                    success: function(dataServer){
                        
                        if (dataServer.retorno == 1){

                             $("#U"+id).html("<span class='btn btn-block btn-outline-success btn-xs' style='width:30px;'>s</span><br>"+dataServer.data);
                             $("#V"+id).html(dataServer.valor_servico+"<br>"+dataServer.desconto);
                             $("#btn"+id).hide();

                             toastr.success('Cupom atualizado com sucesso.');
                            
                        }
                        else  toastr.error(dataServer.mensagem, 'ERRO!'); 
                         
                        
                    },
                    error: function(){
                        toastr.error('Ocorreu um erro ao executar a tarefa.', 'ERRO!'); 
                    }

                });
        }
    }
    
}



