function listarBanners(paginador) {


        $.ajax({
        url: "../api/bannerListar.php",
        type: "POST",
        data: "paginador="+paginador,
        dataType: "json",
        cache: false,
        success: function(dataServer){
            

            if (dataServer.retorno == 1){

                var novaLinha="";

                function percorreElementos(elemento){
                    
                    

                    novaLinha += "<tr id='R"+elemento.id+"'>";
                    novaLinha += "<td>"+elemento.id+"</td>";
                    novaLinha += "<td id='N"+elemento.id+"'>"+elemento.descricao+"</td>";
                    novaLinha += "<td>"+elemento.ordem+"</td>";
                    novaLinha += "<td>"+elemento.validade+"</td>";

                    novaLinha += "<td> ";
                    if (elemento.tipo == 'P') novaLinha += "<span class='btn btn-block btn-outline-primary btn-xs' style='width:30px;'>P</span>";
                    if (elemento.tipo == 'G') novaLinha += "<span class='btn btn-block btn-outline-warning btn-xs' style='width:30px;'>G</span>";
                    novaLinha += "</td>";
                    
                    if (elemento.ativo == 'S') novaLinha += "<td><span class='btn btn-block btn-outline-success btn-xs' style='width:30px;'>s</span></td>";
                    else novaLinha += "<td><span class='btn btn-block btn-outline-danger btn-xs' style='width:30px;'>n</span></td>";

                    novaLinha += "<td>";
                    novaLinha += botaoEditar.replace("<#conteudo#>", "bannerEditar("+elemento.id+")")+"&nbsp;";
                    novaLinha += botaoExcluir.replace("<#conteudo#>", "bannerExcluirConfirmacao("+elemento.id+")")+"&nbsp;";
                    novaLinha += botaoImagem.replace("<#conteudo#>", "bannerEditarImagem("+elemento.id+")")+"&nbsp;";
                    
                    novaLinha += "</td>";

                    novaLinha += "</tr>";
                    
                    $("#listaBanners").append(novaLinha);

                    novaLinha = "";
                }
                dataServer.banners.forEach(percorreElementos);
            }

            $('#listaBanners').DataTable( {
                "dom": 'Bfrtip',
                "buttons": [
                    'colvis',
                    'excel',
                    'pdf',
                    'print'
                ],
                "language": {"url": "./inc/DataTable-pt-BR.json"},
                "responsive" : true,
                "lengthChange": false,
                "autoWidth": false,
                "pageLength": 100,
                "order": []
            } );   

            
        },
        error: function(){
            toastr.error('Ocorreu um erro ao acessar os dados.', 'ERRO!'); 
        }


    });

    
}

function bannerExcluirConfirmacao(id){
    
    $("#modalExclusaoMensagem").text('Deseja excluir o banner "'+$("#N"+id).text()+'"?'); 
    $("#modalExclusaoBotao").attr("onclick", "bannerExcluir("+id+")");
    $('#modalExclusao').modal('show');
    
}


function bannerExcluir(id){
    
    $('#modalExclusao').modal('hide');
    $.ajax({
        url: "../api/bannerExcluir.php",
        type: "GET",
        data: "id="+id,
        dataType: "json",
        cache: false,
        success: function(dataServer){
            
            if (dataServer.retorno == 1){

                 $("#R"+id).fadeOut(400); 
                 toastr.success('Registro excluido com sucesso.');
                
            }
            else toastr.error('Ocorreu um erro ao executar a tarefa.', 'ERRO!'); 
            
        },
        error: function(){
            toastr.error('Ocorreu um erro ao executar a tarefa.', 'ERRO!'); 
        }

    });
    
}

function bannerNovo(){
    carregaPagina('bannerNovoForm');
}


function carregarSelectOfertas(id){

    $.ajax({
        url: "../api/ofertaCarregarSelect.php",
        type: "GET",
        dataType: "json",
        cache: false,
        success: function(dataServer){
            
            if (dataServer.retorno == 1){

                var novaLinha="<option value='-1'>Selecione uma oferta</option>";

                function percorreElementos(elemento){
                    
                    novaLinha += "<option value='"+elemento.id+"'>"+elemento.titulo+"</option>";
                    
                    $("[name='id_oferta']").append(novaLinha);

                    novaLinha = "";

                }
                dataServer.ofertas.forEach(percorreElementos);
                
            }
            else $("[name='id_oferta']").html("<option value='-1'>Selecione uma oferta</option>");
            
            $("[name='id_oferta']").val(id);
            
            $(".select2").select2({
              tags: true
            });
            $("[role='combobox']").css("height", "39");
            $("[role='presentation']").css("height", "39");


        },
        error: function(){
            toastr.error('Ocorreu um erro ao carregar as empresas.', 'ERRO!'); 
        }

    });
}


function bannerSalvar(tipo){

    
    loader('on');


    if ($('[name="descricao"]').val() == '' || $('[name="validade"]').val() == ''){toastr.warning('Os campos Descrição e Validade devem ser preenchidos, ATENÇÃO!'); loader('off');}
    else{

            var data = $("#formBanner").serialize();

            $.ajax({
                url: "../api/bannerSalvar.php",
                type: "POST",
                data: data,
                dataType: "json",
                cache: false,
                success: function(dataServer){
                    
                    if (dataServer.retorno == 1) {
                        toastr.success('Registro criado com sucesso.');
                        if (tipo == "N"){
                            bannerEditarImagem(dataServer.id,'N');
                        }
                        else carregaPagina('banners');
                    }
                    else toastr.error('Ocorreu um erro ao executar a tarefa.', 'ERRO!'); 

                    loader('off');
                    
                },
                error: function(){
                    toastr.error('Ocorreu um erro ao executar a tarefa.', 'ERRO!'); 
                }

            });
        }
        
}


function bannerEditarImagem(id, tipo){

    carregaPagina('bannerEditarImagem',id,tipo);

}


function bannerImagem(id, tipo){

    bsCustomFileInput.init();
    
    $("#id").val(id);

    bannerArquivoImagem(id);

    if (tipo == 'N'){
        $("#caminhoPao").html("Novo");
        $("#titulo").html("Novo Banner");
    }

    $('#bannerImagem').change(function (event) {
        form = new FormData();
        form.append('bannerImagem', event.target.files[0]); // para apenas 1 arquivo
        form.append('id', id);
        //var name = event.target.files[0].content.name; // para capturar o nome do arquivo com sua extenção
    });

    $('#botaoEnviar').click(function () {
        $(".loader").show();
        $.ajax({
            url: '../api/bannerUploadImagem.php', // Url do lado server que vai receber o arquivo
            data: form,
            processData: false,
            contentType: false,
            type: 'POST',
            dataType: "json",
            success: function (dataServer) {
                console.log(dataServer);
                console.log(dataServer.mensagem);
                $(".loader").hide();
                if (dataServer.retorno == 1) {
                    bannerArquivoImagem(id);
                    toastr.success('Imagem incluida com sucesso.');
                }
                else toastr.error(dataServer.mensagem, 'ERRO!'); 
                
                
            }
        });
    });
   

}



function bannerArquivoImagem(id){

    $.ajax({
        url: "../api/bannerArquivoImagem.php",
        type: "GET",
        data: "id="+id,
        dataType: "json",
        cache: false,
        success: function(dataServer){
            

            if (dataServer.retorno == 1) {
                $("#imagem").attr('src',dataServer.imagem);
                $("#imagem").show();
                $("#botaoExcluirImagem").show();
            }
            else{
                $("#imagem").hide();
                $("#botaoExcluirImagem").hide();
            }
            
            
        },
        error: function(){
            toastr.error('Ocorreu um erro ao acessar os dados.', 'ERRO!'); 
        }


    });

    
}



function bannerEditar(id){
    carregaPagina('bannerEditarForm', id);
}



function carregaDadosBanner(id) {


        $.ajax({
        url: "../api/bannerDados.php",
        type: "POST",
        data: "id="+id,
        dataType: "json",
        cache: false,
        success: function(dataServer){
            

            if (dataServer.retorno == 1){

                   $("[name='id']").val(dataServer.banners[0].id);
                   $("[name='tipo']").val(dataServer.banners[0].tipo);
                   $("[name='descricao']").val(dataServer.banners[0].descricao); 
                   $("[name='validade']").val(dataServer.banners[0].validade); 
                   $("[name='ordem']").val(dataServer.banners[0].ordem); 
                   $("[name='ativo']").val(dataServer.banners[0].ativo);
                   
                   carregarSelectOfertas(dataServer.banners[0].id_oferta);
            }
            else toastr.error('Registro não localizado.', 'ERRO!'); 
            
        },
        error: function(){
            toastr.error('Ocorreu um erro ao acessar os dados.', 'ERRO!'); 
        }


    });

    
}


function bannerImagemExcluirConfirmacao(){
    
    $("#modalExclusaoMensagem").text("Deseja excluir a imagem ?"); 
    $("#modalExclusaoBotao").attr("onclick", "bannerExcluirImagem()");
    $('#modalExclusao').modal('show');
    
}


function bannerExcluirImagem(){
    
    $('#modalExclusao').modal('hide');
    $('#botaoExcluirImagem').hide();
    $('.loader').show();

    var id = $("#id").val();

    $.ajax({
        url: "../api/bannerExcluirImagem.php",
        type: "GET",
        data: "id="+id,
        dataType: "json",
        cache: false,
        success: function(dataServer){
            
            $('.loader').hide();

            if (dataServer.retorno == 1){

                 $('#imagem').hide();
                 toastr.success('Imagem excluida com sucesso.');
                
            }
            else {
                $('#botaoExcluirImagem').show();
                toastr.error('Ocorreu um erro ao executar a tarefa.', 'ERRO!'); 
            }
            
        },
        error: function(){
            $('#botaoExcluirImagem').show();
            toastr.error('Ocorreu um erro ao executar a tarefa.', 'ERRO!'); 
        }

    });
    
}

